string GetDescription()
{
	return "Renders the harmony into a track with simple chords with simple arpeggio";
}

void Render(RenderPart @p)
{
	int div = 20;
	int speed = RndInt(0,2);
	if (speed == 0) div = 20;
	if (speed == 1) div = 40;
	if (speed == 2) div = 12;
		
	for (int i = 0; i < p.GetHarmonicEvents(); i++)
	{
		for (int f = 0; f < 3; f++)
		{
			Time t1 = p.GetHarmonicEventStart(i);
			Time t2 = p.GetHarmonicEventEnd(i);
			
			t1.m_Pos -= (p.GetHarmonicComponents(i)-f)/20.0;
			t2.m_Pos -= (p.GetHarmonicComponents(i)-f)/20.0;
						
			p.AddNote(t1, t2, p.GetHarmonicEventPitch(i,f),127);	
		}
	}
}